/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;

public final class ListInstancesPaginator
implements SdkIterable<ListInstancesResponse> {
    private final ServiceDiscoveryClient client;
    private final ListInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstancesPaginator(ServiceDiscoveryClient client, ListInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public Iterator<ListInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListInstancesResponseFetcher
    implements NextPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListInstancesResponse nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesPaginator.this.client.listInstances(ListInstancesPaginator.this.firstRequest);
            }
            return ListInstancesPaginator.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

