/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecord;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecordListCopier;
import software.amazon.awssdk.services.servicediscovery.transform.DnsConfigChangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DnsConfigChange
implements StructuredPojo,
ToCopyableBuilder<Builder, DnsConfigChange> {
    private final List<DnsRecord> dnsRecords;

    private DnsConfigChange(BuilderImpl builder) {
        this.dnsRecords = builder.dnsRecords;
    }

    public List<DnsRecord> dnsRecords() {
        return this.dnsRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfigChange)) {
            return false;
        }
        DnsConfigChange other = (DnsConfigChange)obj;
        return Objects.equals(this.dnsRecords(), other.dnsRecords());
    }

    public String toString() {
        return ToString.builder((String)"DnsConfigChange").add("DnsRecords", this.dnsRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsRecords": {
                return Optional.of(clazz.cast(this.dnsRecords()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsConfigChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DnsRecord> dnsRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfigChange model) {
            this.dnsRecords(model.dnsRecords);
        }

        public final Collection<DnsRecord.Builder> getDnsRecords() {
            return this.dnsRecords != null ? (Collection)this.dnsRecords.stream().map(DnsRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsRecords(Collection<DnsRecord> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copy(dnsRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(DnsRecord ... dnsRecords) {
            this.dnsRecords(Arrays.asList(dnsRecords));
            return this;
        }

        public final void setDnsRecords(Collection<DnsRecord.BuilderImpl> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copyFromBuilder(dnsRecords);
        }

        public DnsConfigChange build() {
            return new DnsConfigChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DnsConfigChange> {
        public Builder dnsRecords(Collection<DnsRecord> var1);

        public Builder dnsRecords(DnsRecord ... var1);
    }
}

