/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicediscovery.DefaultServiceDiscoveryClientBuilder;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClientBuilder;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsPaginator;
import software.amazon.awssdk.services.servicediscovery.paginators.ListServicesPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface ServiceDiscoveryClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "servicediscovery";

    public static ServiceDiscoveryClient create() {
        return (ServiceDiscoveryClient)ServiceDiscoveryClient.builder().build();
    }

    public static ServiceDiscoveryClientBuilder builder() {
        return new DefaultServiceDiscoveryClientBuilder();
    }

    default public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(Consumer<CreatePrivateDnsNamespaceRequest.Builder> createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createPrivateDnsNamespace((CreatePrivateDnsNamespaceRequest)((Object)((CreatePrivateDnsNamespaceRequest.Builder)CreatePrivateDnsNamespaceRequest.builder().apply(createPrivateDnsNamespaceRequest)).build()));
    }

    default public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(Consumer<CreatePublicDnsNamespaceRequest.Builder> createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createPublicDnsNamespace((CreatePublicDnsNamespaceRequest)((Object)((CreatePublicDnsNamespaceRequest.Builder)CreatePublicDnsNamespaceRequest.builder().apply(createPublicDnsNamespaceRequest)).build()));
    }

    default public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public CreateServiceResponse createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.createService((CreateServiceRequest)((Object)((CreateServiceRequest.Builder)CreateServiceRequest.builder().apply(createServiceRequest)).build()));
    }

    default public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deleteNamespace((DeleteNamespaceRequest)((Object)((DeleteNamespaceRequest.Builder)DeleteNamespaceRequest.builder().apply(deleteNamespaceRequest)).build()));
    }

    default public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeleteServiceResponse deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deleteService((DeleteServiceRequest)((Object)((DeleteServiceRequest.Builder)DeleteServiceRequest.builder().apply(deleteServiceRequest)).build()));
    }

    default public DeregisterInstanceResponse deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public DeregisterInstanceResponse deregisterInstance(Consumer<DeregisterInstanceRequest.Builder> deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.deregisterInstance((DeregisterInstanceRequest)((Object)((DeregisterInstanceRequest.Builder)DeregisterInstanceRequest.builder().apply(deregisterInstanceRequest)).build()));
    }

    default public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetInstanceResponse getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getInstance((GetInstanceRequest)((Object)((GetInstanceRequest.Builder)GetInstanceRequest.builder().apply(getInstanceRequest)).build()));
    }

    default public GetInstancesHealthStatusResponse getInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetInstancesHealthStatusResponse getInstancesHealthStatus(Consumer<GetInstancesHealthStatusRequest.Builder> getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getInstancesHealthStatus((GetInstancesHealthStatusRequest)((Object)((GetInstancesHealthStatusRequest.Builder)GetInstancesHealthStatusRequest.builder().apply(getInstancesHealthStatusRequest)).build()));
    }

    default public GetInstancesHealthStatusPaginator getInstancesHealthStatusIterable(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetNamespaceResponse getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getNamespace((GetNamespaceRequest)((Object)((GetNamespaceRequest.Builder)GetNamespaceRequest.builder().apply(getNamespaceRequest)).build()));
    }

    default public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws OperationNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) throws OperationNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getOperation((GetOperationRequest)((Object)((GetOperationRequest.Builder)GetOperationRequest.builder().apply(getOperationRequest)).build()));
    }

    default public GetServiceResponse getService(GetServiceRequest getServiceRequest) throws InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public GetServiceResponse getService(Consumer<GetServiceRequest.Builder> getServiceRequest) throws InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.getService((GetServiceRequest)((Object)((GetServiceRequest.Builder)GetServiceRequest.builder().apply(getServiceRequest)).build()));
    }

    default public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listInstances((ListInstancesRequest)((Object)((ListInstancesRequest.Builder)ListInstancesRequest.builder().apply(listInstancesRequest)).build()));
    }

    default public ListInstancesPaginator listInstancesIterable(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListNamespacesResponse listNamespaces() throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesRequest.builder().build()));
    }

    default public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespaces((ListNamespacesRequest)((Object)((ListNamespacesRequest.Builder)ListNamespacesRequest.builder().apply(listNamespacesRequest)).build()));
    }

    default public ListNamespacesPaginator listNamespacesIterable() throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listNamespacesIterable((ListNamespacesRequest)((Object)ListNamespacesRequest.builder().build()));
    }

    default public ListNamespacesPaginator listNamespacesIterable(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListOperationsResponse listOperations() throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperations((ListOperationsRequest)((Object)ListOperationsRequest.builder().build()));
    }

    default public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperations((ListOperationsRequest)((Object)((ListOperationsRequest.Builder)ListOperationsRequest.builder().apply(listOperationsRequest)).build()));
    }

    default public ListOperationsPaginator listOperationsIterable() throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listOperationsIterable((ListOperationsRequest)((Object)ListOperationsRequest.builder().build()));
    }

    default public ListOperationsPaginator listOperationsIterable(ListOperationsRequest listOperationsRequest) throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListServicesResponse listServices() throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServices((ListServicesRequest)((Object)ListServicesRequest.builder().build()));
    }

    default public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServices((ListServicesRequest)((Object)((ListServicesRequest.Builder)ListServicesRequest.builder().apply(listServicesRequest)).build()));
    }

    default public ListServicesPaginator listServicesIterable() throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.listServicesIterable((ListServicesRequest)((Object)ListServicesRequest.builder().build()));
    }

    default public ListServicesPaginator listServicesIterable(ListServicesRequest listServicesRequest) throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public RegisterInstanceResponse registerInstance(RegisterInstanceRequest registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public RegisterInstanceResponse registerInstance(Consumer<RegisterInstanceRequest.Builder> registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.registerInstance((RegisterInstanceRequest)((Object)((RegisterInstanceRequest.Builder)RegisterInstanceRequest.builder().apply(registerInstanceRequest)).build()));
    }

    default public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    default public UpdateServiceResponse updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return this.updateService((UpdateServiceRequest)((Object)((UpdateServiceRequest.Builder)UpdateServiceRequest.builder().apply(updateServiceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

