/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.ServiceSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final ServiceSummaryMarshaller INSTANCE = new ServiceSummaryMarshaller();

    private ServiceSummaryMarshaller() {
    }

    public static ServiceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceSummary serviceSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceSummary, (String)"serviceSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)serviceSummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)serviceSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)serviceSummary.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)serviceSummary.instanceCount(), INSTANCECOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

