/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfig;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private final String name;
    private final String creatorRequestId;
    private final String description;
    private final DnsConfig dnsConfig;
    private final HealthCheckConfig healthCheckConfig;
    private final HealthCheckCustomConfig healthCheckCustomConfig;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckCustomConfig = builder.healthCheckCustomConfig;
    }

    public String name() {
        return this.name;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String description() {
        return this.description;
    }

    public DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public HealthCheckCustomConfig healthCheckCustomConfig() {
        return this.healthCheckCustomConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckCustomConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsConfig(), other.dnsConfig()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig()) && Objects.equals(this.healthCheckCustomConfig(), other.healthCheckCustomConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("Name", (Object)this.name()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Description", (Object)this.description()).add("DnsConfig", (Object)this.dnsConfig()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).add("HealthCheckCustomConfig", (Object)this.healthCheckCustomConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DnsConfig": {
                return Optional.ofNullable(clazz.cast(this.dnsConfig()));
            }
            case "HealthCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfig()));
            }
            case "HealthCheckCustomConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckCustomConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String creatorRequestId;
        private String description;
        private DnsConfig dnsConfig;
        private HealthCheckConfig healthCheckConfig;
        private HealthCheckCustomConfig healthCheckCustomConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.name(model.name);
            this.creatorRequestId(model.creatorRequestId);
            this.description(model.description);
            this.dnsConfig(model.dnsConfig);
            this.healthCheckConfig(model.healthCheckConfig);
            this.healthCheckCustomConfig(model.healthCheckCustomConfig);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return this.dnsConfig != null ? this.dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final HealthCheckCustomConfig.Builder getHealthCheckCustomConfig() {
            return this.healthCheckCustomConfig != null ? this.healthCheckCustomConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig;
            return this;
        }

        public final void setHealthCheckCustomConfig(HealthCheckCustomConfig.BuilderImpl healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig != null ? healthCheckCustomConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder name(String var1);

        public Builder creatorRequestId(String var1);

        public Builder description(String var1);

        public Builder dnsConfig(DnsConfig var1);

        default public Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return this.dnsConfig((DnsConfig)((DnsConfig.Builder)DnsConfig.builder().applyMutation(dnsConfig)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheckConfig)).build());
        }

        public Builder healthCheckCustomConfig(HealthCheckCustomConfig var1);

        default public Builder healthCheckCustomConfig(Consumer<HealthCheckCustomConfig.Builder> healthCheckCustomConfig) {
            return this.healthCheckCustomConfig((HealthCheckCustomConfig)((HealthCheckCustomConfig.Builder)HealthCheckCustomConfig.builder().applyMutation(healthCheckCustomConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

