/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.Operation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OperationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> UPDATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateDate").isBinary(false).build();
    private static final MarshallingInfo<Map> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final OperationMarshaller INSTANCE = new OperationMarshaller();

    private OperationMarshaller() {
    }

    public static OperationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Operation operation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)operation, (String)"operation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)operation.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)operation.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)operation.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)operation.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)operation.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)operation.createDate(), CREATEDATE_BINDING);
            protocolMarshaller.marshall((Object)operation.updateDate(), UPDATEDATE_BINDING);
            protocolMarshaller.marshall(operation.targetsAsStrings(), TARGETS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

