/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DnsConfigMarshaller {
    private static final MarshallingInfo<String> NAMESPACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamespaceId").isBinary(false).build();
    private static final MarshallingInfo<List> DNSRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsRecords").isBinary(false).build();
    private static final DnsConfigMarshaller INSTANCE = new DnsConfigMarshaller();

    private DnsConfigMarshaller() {
    }

    public static DnsConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DnsConfig dnsConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dnsConfig, (String)"dnsConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dnsConfig.namespaceId(), NAMESPACEID_BINDING);
            protocolMarshaller.marshall(dnsConfig.dnsRecords(), DNSRECORDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

