/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateServiceRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> CREATORREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatorRequestId").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DNSCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HEALTHCHECKCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HealthCheckConfig").isBinary(false).build();
    private static final CreateServiceRequestModelMarshaller INSTANCE = new CreateServiceRequestModelMarshaller();

    private CreateServiceRequestModelMarshaller() {
    }

    public static CreateServiceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateServiceRequest createServiceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createServiceRequest), (String)"createServiceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createServiceRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createServiceRequest.creatorRequestId(), CREATORREQUESTID_BINDING);
            protocolMarshaller.marshall((Object)createServiceRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createServiceRequest.dnsConfig(), DNSCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createServiceRequest.healthCheckConfig(), HEALTHCHECKCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

