/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.OperationFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OperationFilterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Condition").isBinary(false).build();
    private static final OperationFilterMarshaller INSTANCE = new OperationFilterMarshaller();

    private OperationFilterMarshaller() {
    }

    public static OperationFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OperationFilter operationFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)operationFilter, (String)"operationFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)operationFilter.nameAsString(), NAME_BINDING);
            protocolMarshaller.marshall(operationFilter.values(), VALUES_BINDING);
            protocolMarshaller.marshall((Object)operationFilter.conditionAsString(), CONDITION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

