/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.services.servicediscovery.model.ServiceSummariesListCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListServicesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, ListServicesResponse> {
    private final List<ServiceSummary> services;
    private final String nextToken;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public List<ServiceSummary> services() {
        return this.services;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse)((Object)obj);
        return Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListServicesResponse").add("Services", this.services()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.of(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<ServiceSummary> services;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            this.services(model.services);
            this.nextToken(model.nextToken);
        }

        public final Collection<ServiceSummary.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(ServiceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ServiceSummary> services) {
            this.services = ServiceSummariesListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceSummary ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceSummary.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (ServiceSummary)((ServiceSummary.Builder)ServiceSummary.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ServiceSummary.BuilderImpl> services) {
            this.services = ServiceSummariesListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    CopyableBuilder<Builder, ListServicesResponse> {
        public Builder services(Collection<ServiceSummary> var1);

        public Builder services(ServiceSummary ... var1);

        public Builder services(Consumer<ServiceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

