/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAttributeGroupRequest
extends ServiceCatalogAppRegistryRequest
implements ToCopyableBuilder<Builder, AssociateAttributeGroupRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(AssociateAttributeGroupRequest.getter(AssociateAttributeGroupRequest::application)).setter(AssociateAttributeGroupRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()}).build();
    private static final SdkField<String> ATTRIBUTE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeGroup").getter(AssociateAttributeGroupRequest.getter(AssociateAttributeGroupRequest::attributeGroup)).setter(AssociateAttributeGroupRequest.setter(Builder::attributeGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("attributeGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, ATTRIBUTE_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateAttributeGroupRequest.memberNameToFieldInitializer();
    private final String application;
    private final String attributeGroup;

    private AssociateAttributeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.attributeGroup = builder.attributeGroup;
    }

    public final String application() {
        return this.application;
    }

    public final String attributeGroup() {
        return this.attributeGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAttributeGroupRequest)) {
            return false;
        }
        AssociateAttributeGroupRequest other = (AssociateAttributeGroupRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.attributeGroup(), other.attributeGroup());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAttributeGroupRequest").add("Application", (Object)this.application()).add("AttributeGroup", (Object)this.attributeGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "attributeGroup": {
                return Optional.ofNullable(clazz.cast(this.attributeGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("application", APPLICATION_FIELD);
        map.put("attributeGroup", ATTRIBUTE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAttributeGroupRequest, T> g) {
        return obj -> g.apply((AssociateAttributeGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryRequest.BuilderImpl
    implements Builder {
        private String application;
        private String attributeGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAttributeGroupRequest model) {
            super(model);
            this.application(model.application);
            this.attributeGroup(model.attributeGroup);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getAttributeGroup() {
            return this.attributeGroup;
        }

        public final void setAttributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
        }

        @Override
        public final Builder attributeGroup(String attributeGroup) {
            this.attributeGroup = attributeGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAttributeGroupRequest build() {
            return new AssociateAttributeGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogAppRegistryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAttributeGroupRequest> {
        public Builder application(String var1);

        public Builder attributeGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

