/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceGroupState {
    CREATING("CREATING"),
    CREATE_COMPLETE("CREATE_COMPLETE"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATING("UPDATING"),
    UPDATE_COMPLETE("UPDATE_COMPLETE"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceGroupState> VALUE_MAP;
    private final String value;

    private ResourceGroupState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceGroupState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceGroupState> knownValues() {
        EnumSet<ResourceGroupState> knownValues = EnumSet.allOf(ResourceGroupState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceGroupState.class, ResourceGroupState::toString);
    }
}

