/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Integrations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Integrations> {
    private static final SdkField<ResourceGroup> RESOURCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceGroup").getter(Integrations.getter(Integrations::resourceGroup)).setter(Integrations.setter(Builder::resourceGroup)).constructor(ResourceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroup").build()}).build();
    private static final SdkField<ResourceGroup> APPLICATION_TAG_RESOURCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("applicationTagResourceGroup").getter(Integrations.getter(Integrations::applicationTagResourceGroup)).setter(Integrations.setter(Builder::applicationTagResourceGroup)).constructor(ResourceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagResourceGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_FIELD, APPLICATION_TAG_RESOURCE_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceGroup", RESOURCE_GROUP_FIELD);
            this.put("applicationTagResourceGroup", APPLICATION_TAG_RESOURCE_GROUP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResourceGroup resourceGroup;
    private final ResourceGroup applicationTagResourceGroup;

    private Integrations(BuilderImpl builder) {
        this.resourceGroup = builder.resourceGroup;
        this.applicationTagResourceGroup = builder.applicationTagResourceGroup;
    }

    public final ResourceGroup resourceGroup() {
        return this.resourceGroup;
    }

    public final ResourceGroup applicationTagResourceGroup() {
        return this.applicationTagResourceGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTagResourceGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integrations)) {
            return false;
        }
        Integrations other = (Integrations)obj;
        return Objects.equals(this.resourceGroup(), other.resourceGroup()) && Objects.equals(this.applicationTagResourceGroup(), other.applicationTagResourceGroup());
    }

    public final String toString() {
        return ToString.builder((String)"Integrations").add("ResourceGroup", (Object)this.resourceGroup()).add("ApplicationTagResourceGroup", (Object)this.applicationTagResourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroup": {
                return Optional.ofNullable(clazz.cast(this.resourceGroup()));
            }
            case "applicationTagResourceGroup": {
                return Optional.ofNullable(clazz.cast(this.applicationTagResourceGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Integrations, T> g) {
        return obj -> g.apply((Integrations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceGroup resourceGroup;
        private ResourceGroup applicationTagResourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(Integrations model) {
            this.resourceGroup(model.resourceGroup);
            this.applicationTagResourceGroup(model.applicationTagResourceGroup);
        }

        public final ResourceGroup.Builder getResourceGroup() {
            return this.resourceGroup != null ? this.resourceGroup.toBuilder() : null;
        }

        public final void setResourceGroup(ResourceGroup.BuilderImpl resourceGroup) {
            this.resourceGroup = resourceGroup != null ? resourceGroup.build() : null;
        }

        @Override
        public final Builder resourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public final ResourceGroup.Builder getApplicationTagResourceGroup() {
            return this.applicationTagResourceGroup != null ? this.applicationTagResourceGroup.toBuilder() : null;
        }

        public final void setApplicationTagResourceGroup(ResourceGroup.BuilderImpl applicationTagResourceGroup) {
            this.applicationTagResourceGroup = applicationTagResourceGroup != null ? applicationTagResourceGroup.build() : null;
        }

        @Override
        public final Builder applicationTagResourceGroup(ResourceGroup applicationTagResourceGroup) {
            this.applicationTagResourceGroup = applicationTagResourceGroup;
            return this;
        }

        public Integrations build() {
            return new Integrations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Integrations> {
        public Builder resourceGroup(ResourceGroup var1);

        default public Builder resourceGroup(Consumer<ResourceGroup.Builder> resourceGroup) {
            return this.resourceGroup((ResourceGroup)((ResourceGroup.Builder)ResourceGroup.builder().applyMutation(resourceGroup)).build());
        }

        public Builder applicationTagResourceGroup(ResourceGroup var1);

        default public Builder applicationTagResourceGroup(Consumer<ResourceGroup.Builder> applicationTagResourceGroup) {
            return this.applicationTagResourceGroup((ResourceGroup)((ResourceGroup.Builder)ResourceGroup.builder().applyMutation(applicationTagResourceGroup)).build());
        }
    }
}

