/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryAsyncClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupSummary;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse;

public class ListAttributeGroupsPublisher
implements SdkPublisher<ListAttributeGroupsResponse> {
    private final ServiceCatalogAppRegistryAsyncClient client;
    private final ListAttributeGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttributeGroupsPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAttributeGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttributeGroupsPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAttributeGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttributeGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttributeGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttributeGroupSummary> attributeGroups() {
        Function<ListAttributeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroups() != null) {
                return response.attributeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttributeGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttributeGroupsResponseFetcher
    implements AsyncPageFetcher<ListAttributeGroupsResponse> {
        private ListAttributeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttributeGroupsResponse> nextPage(ListAttributeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAttributeGroupsPublisher.this.client.listAttributeGroups(ListAttributeGroupsPublisher.this.firstRequest);
            }
            return ListAttributeGroupsPublisher.this.client.listAttributeGroups((ListAttributeGroupsRequest)((Object)ListAttributeGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

