/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupDetails;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse;

public class ListAttributeGroupsForApplicationIterable
implements SdkIterable<ListAttributeGroupsForApplicationResponse> {
    private final ServiceCatalogAppRegistryClient client;
    private final ListAttributeGroupsForApplicationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttributeGroupsForApplicationIterable(ServiceCatalogAppRegistryClient client, ListAttributeGroupsForApplicationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAttributeGroupsForApplicationResponseFetcher();
    }

    public Iterator<ListAttributeGroupsForApplicationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttributeGroupDetails> attributeGroupsDetails() {
        Function<ListAttributeGroupsForApplicationResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroupsDetails() != null) {
                return response.attributeGroupsDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttributeGroupsForApplicationResponseFetcher
    implements SyncPageFetcher<ListAttributeGroupsForApplicationResponse> {
        private ListAttributeGroupsForApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributeGroupsForApplicationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttributeGroupsForApplicationResponse nextPage(ListAttributeGroupsForApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListAttributeGroupsForApplicationIterable.this.client.listAttributeGroupsForApplication(ListAttributeGroupsForApplicationIterable.this.firstRequest);
            }
            return ListAttributeGroupsForApplicationIterable.this.client.listAttributeGroupsForApplication((ListAttributeGroupsForApplicationRequest)((Object)ListAttributeGroupsForApplicationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

