/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceType;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssociatedResourceRequest
extends ServiceCatalogAppRegistryRequest
implements ToCopyableBuilder<Builder, GetAssociatedResourceRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::application)).setter(GetAssociatedResourceRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::resourceTypeAsString)).setter(GetAssociatedResourceRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(GetAssociatedResourceRequest.getter(GetAssociatedResourceRequest::resource)).setter(GetAssociatedResourceRequest.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_FIELD));
    private final String application;
    private final String resourceType;
    private final String resource;

    private GetAssociatedResourceRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
    }

    public final String application() {
        return this.application;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resource() {
        return this.resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceRequest)) {
            return false;
        }
        GetAssociatedResourceRequest other = (GetAssociatedResourceRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssociatedResourceRequest").add("Application", (Object)this.application()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedResourceRequest, T> g) {
        return obj -> g.apply((GetAssociatedResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryRequest.BuilderImpl
    implements Builder {
        private String application;
        private String resourceType;
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedResourceRequest model) {
            super(model);
            this.application(model.application);
            this.resourceType(model.resourceType);
            this.resource(model.resource);
        }

        public final String getApplication() {
            return this.application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        @Transient
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        @Transient
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssociatedResourceRequest build() {
            return new GetAssociatedResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssociatedResourceRequest> {
        public Builder application(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resource(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

