/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryAsyncClient;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse;

public class ListAssociatedAttributeGroupsPublisher
implements SdkPublisher<ListAssociatedAttributeGroupsResponse> {
    private final ServiceCatalogAppRegistryAsyncClient client;
    private final ListAssociatedAttributeGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedAttributeGroupsPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAssociatedAttributeGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedAttributeGroupsPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAssociatedAttributeGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedAttributeGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedAttributeGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> attributeGroups() {
        Function<ListAssociatedAttributeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeGroups() != null) {
                return response.attributeGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociatedAttributeGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssociatedAttributeGroupsResponseFetcher
    implements AsyncPageFetcher<ListAssociatedAttributeGroupsResponse> {
        private ListAssociatedAttributeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAttributeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedAttributeGroupsResponse> nextPage(ListAssociatedAttributeGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAttributeGroupsPublisher.this.client.listAssociatedAttributeGroups(ListAssociatedAttributeGroupsPublisher.this.firstRequest);
            }
            return ListAssociatedAttributeGroupsPublisher.this.client.listAssociatedAttributeGroups((ListAssociatedAttributeGroupsRequest)((Object)ListAssociatedAttributeGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

