/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProductsAsAdminResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, SearchProductsAsAdminResponse> {
    private static final SdkField<List<ProductViewDetail>> PRODUCT_VIEW_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchProductsAsAdminResponse.getter(SearchProductsAsAdminResponse::productViewDetails)).setter(SearchProductsAsAdminResponse.setter(Builder::productViewDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductViewDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminResponse.getter(SearchProductsAsAdminResponse::nextPageToken)).setter(SearchProductsAsAdminResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAILS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ProductViewDetail> productViewDetails;
    private final String nextPageToken;

    private SearchProductsAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetails = builder.productViewDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProductViewDetail> productViewDetails() {
        return this.productViewDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminResponse)) {
            return false;
        }
        SearchProductsAsAdminResponse other = (SearchProductsAsAdminResponse)((Object)obj);
        return Objects.equals(this.productViewDetails(), other.productViewDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"SearchProductsAsAdminResponse").add("ProductViewDetails", this.productViewDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetails": {
                return Optional.ofNullable(clazz.cast(this.productViewDetails()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsAsAdminResponse, T> g) {
        return obj -> g.apply((SearchProductsAsAdminResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProductViewDetail> productViewDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminResponse model) {
            super(model);
            this.productViewDetails(model.productViewDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewDetail.Builder> getProductViewDetails() {
            return this.productViewDetails != null ? (Collection)this.productViewDetails.stream().map(ProductViewDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewDetails(Collection<ProductViewDetail> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copy(productViewDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(ProductViewDetail ... productViewDetails) {
            this.productViewDetails(Arrays.asList(productViewDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(Consumer<ProductViewDetail.Builder> ... productViewDetails) {
            this.productViewDetails(Stream.of(productViewDetails).map(c -> (ProductViewDetail)((ProductViewDetail.Builder)ProductViewDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductViewDetails(Collection<ProductViewDetail.BuilderImpl> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copyFromBuilder(productViewDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsAsAdminResponse build() {
            return new SearchProductsAsAdminResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProductsAsAdminResponse> {
        public Builder productViewDetails(Collection<ProductViewDetail> var1);

        public Builder productViewDetails(ProductViewDetail ... var1);

        public Builder productViewDetails(Consumer<ProductViewDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

