/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisioningParametersRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DescribeProvisioningParametersRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::acceptLanguage)).setter(DescribeProvisioningParametersRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::productId)).setter(DescribeProvisioningParametersRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::provisioningArtifactId)).setter(DescribeProvisioningParametersRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeProvisioningParametersRequest.getter(DescribeProvisioningParametersRequest::pathId)).setter(DescribeProvisioningParametersRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;

    private DescribeProvisioningParametersRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersRequest)) {
            return false;
        }
        DescribeProvisioningParametersRequest other = (DescribeProvisioningParametersRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pathId(), other.pathId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProvisioningParametersRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("PathId", (Object)this.pathId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersRequest, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProvisioningParametersRequest build() {
            return new DescribeProvisioningParametersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProvisioningParametersRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

