/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisioningArtifactRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProvisioningArtifactRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::acceptLanguage)).setter(UpdateProvisioningArtifactRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::productId)).setter(UpdateProvisioningArtifactRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::provisioningArtifactId)).setter(UpdateProvisioningArtifactRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::name)).setter(UpdateProvisioningArtifactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::description)).setter(UpdateProvisioningArtifactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateProvisioningArtifactRequest.getter(UpdateProvisioningArtifactRequest::active)).setter(UpdateProvisioningArtifactRequest.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ACTIVE_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String provisioningArtifactId;
    private final String name;
    private final String description;
    private final Boolean active;

    private UpdateProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.name = builder.name;
        this.description = builder.description;
        this.active = builder.active;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean active() {
        return this.active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningArtifactRequest)) {
            return false;
        }
        UpdateProvisioningArtifactRequest other = (UpdateProvisioningArtifactRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.active(), other.active());
    }

    public String toString() {
        return ToString.builder((String)"UpdateProvisioningArtifactRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Active", (Object)this.active()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((UpdateProvisioningArtifactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String provisioningArtifactId;
        private String name;
        private String description;
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningArtifactRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.name(model.name);
            this.description(model.description);
            this.active(model.active);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisioningArtifactRequest build() {
            return new UpdateProvisioningArtifactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisioningArtifactRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder active(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

