/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceActionDefinitionKey {
    NAME("Name"),
    VERSION("Version"),
    ASSUME_ROLE("AssumeRole"),
    PARAMETERS("Parameters"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceActionDefinitionKey> VALUE_MAP;
    private final String value;

    private ServiceActionDefinitionKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceActionDefinitionKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceActionDefinitionKey> knownValues() {
        EnumSet<ServiceActionDefinitionKey> knownValues = EnumSet.allOf(ServiceActionDefinitionKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceActionDefinitionKey.class, ServiceActionDefinitionKey::toString);
    }
}

