/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;

public class ListOrganizationPortfolioAccessIterable
implements SdkIterable<ListOrganizationPortfolioAccessResponse> {
    private final ServiceCatalogClient client;
    private final ListOrganizationPortfolioAccessRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationPortfolioAccessIterable(ServiceCatalogClient client, ListOrganizationPortfolioAccessRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOrganizationPortfolioAccessResponseFetcher();
    }

    public Iterator<ListOrganizationPortfolioAccessResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListOrganizationPortfolioAccessIterable resume(ListOrganizationPortfolioAccessResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOrganizationPortfolioAccessIterable(this.client, (ListOrganizationPortfolioAccessRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListOrganizationPortfolioAccessIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListOrganizationPortfolioAccessResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListOrganizationPortfolioAccessResponseFetcher
    implements SyncPageFetcher<ListOrganizationPortfolioAccessResponse> {
        private ListOrganizationPortfolioAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationPortfolioAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListOrganizationPortfolioAccessResponse nextPage(ListOrganizationPortfolioAccessResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationPortfolioAccessIterable.this.client.listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessIterable.this.firstRequest);
            }
            return ListOrganizationPortfolioAccessIterable.this.client.listOrganizationPortfolioAccess((ListOrganizationPortfolioAccessRequest)((Object)ListOrganizationPortfolioAccessIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

