/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateServiceActionFromProvisioningArtifactRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DisassociateServiceActionFromProvisioningArtifactRequest> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(DisassociateServiceActionFromProvisioningArtifactRequest.getter(DisassociateServiceActionFromProvisioningArtifactRequest::productId)).setter(DisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(DisassociateServiceActionFromProvisioningArtifactRequest.getter(DisassociateServiceActionFromProvisioningArtifactRequest::provisioningArtifactId)).setter(DisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceActionId").getter(DisassociateServiceActionFromProvisioningArtifactRequest.getter(DisassociateServiceActionFromProvisioningArtifactRequest::serviceActionId)).setter(DisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::serviceActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DisassociateServiceActionFromProvisioningArtifactRequest.getter(DisassociateServiceActionFromProvisioningArtifactRequest::acceptLanguage)).setter(DisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(DisassociateServiceActionFromProvisioningArtifactRequest.getter(DisassociateServiceActionFromProvisioningArtifactRequest::idempotencyToken)).setter(DisassociateServiceActionFromProvisioningArtifactRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, SERVICE_ACTION_ID_FIELD, ACCEPT_LANGUAGE_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProductId", PRODUCT_ID_FIELD);
            this.put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
            this.put("ServiceActionId", SERVICE_ACTION_ID_FIELD);
            this.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        }
    });
    private final String productId;
    private final String provisioningArtifactId;
    private final String serviceActionId;
    private final String acceptLanguage;
    private final String idempotencyToken;

    private DisassociateServiceActionFromProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.serviceActionId = builder.serviceActionId;
        this.acceptLanguage = builder.acceptLanguage;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String serviceActionId() {
        return this.serviceActionId;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateServiceActionFromProvisioningArtifactRequest)) {
            return false;
        }
        DisassociateServiceActionFromProvisioningArtifactRequest other = (DisassociateServiceActionFromProvisioningArtifactRequest)((Object)obj);
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.serviceActionId(), other.serviceActionId()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateServiceActionFromProvisioningArtifactRequest").add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ServiceActionId", (Object)this.serviceActionId()).add("AcceptLanguage", (Object)this.acceptLanguage()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ServiceActionId": {
                return Optional.ofNullable(clazz.cast(this.serviceActionId()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateServiceActionFromProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((DisassociateServiceActionFromProvisioningArtifactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String productId;
        private String provisioningArtifactId;
        private String serviceActionId;
        private String acceptLanguage;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateServiceActionFromProvisioningArtifactRequest model) {
            super(model);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.serviceActionId(model.serviceActionId);
            this.acceptLanguage(model.acceptLanguage);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getServiceActionId() {
            return this.serviceActionId;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateServiceActionFromProvisioningArtifactRequest build() {
            return new DisassociateServiceActionFromProvisioningArtifactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateServiceActionFromProvisioningArtifactRequest> {
        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder serviceActionId(String var1);

        public Builder acceptLanguage(String var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

