/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteServiceActionRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DeleteServiceActionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DeleteServiceActionRequest.getter(DeleteServiceActionRequest::id)).setter(DeleteServiceActionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(DeleteServiceActionRequest.getter(DeleteServiceActionRequest::acceptLanguage)).setter(DeleteServiceActionRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(DeleteServiceActionRequest.getter(DeleteServiceActionRequest::idempotencyToken)).setter(DeleteServiceActionRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCEPT_LANGUAGE_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String id;
    private final String acceptLanguage;
    private final String idempotencyToken;

    private DeleteServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.acceptLanguage = builder.acceptLanguage;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String id() {
        return this.id;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceActionRequest)) {
            return false;
        }
        DeleteServiceActionRequest other = (DeleteServiceActionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteServiceActionRequest").add("Id", (Object)this.id()).add("AcceptLanguage", (Object)this.acceptLanguage()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceActionRequest, T> g) {
        return obj -> g.apply((DeleteServiceActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String id;
        private String acceptLanguage;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceActionRequest model) {
            super(model);
            this.id(model.id);
            this.acceptLanguage(model.acceptLanguage);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceActionRequest build() {
            return new DeleteServiceActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteServiceActionRequest> {
        public Builder id(String var1);

        public Builder acceptLanguage(String var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

