/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateProductWithPortfolioRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, AssociateProductWithPortfolioRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(AssociateProductWithPortfolioRequest.getter(AssociateProductWithPortfolioRequest::acceptLanguage)).setter(AssociateProductWithPortfolioRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(AssociateProductWithPortfolioRequest.getter(AssociateProductWithPortfolioRequest::productId)).setter(AssociateProductWithPortfolioRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortfolioId").getter(AssociateProductWithPortfolioRequest.getter(AssociateProductWithPortfolioRequest::portfolioId)).setter(AssociateProductWithPortfolioRequest.setter(Builder::portfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()}).build();
    private static final SdkField<String> SOURCE_PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePortfolioId").getter(AssociateProductWithPortfolioRequest.getter(AssociateProductWithPortfolioRequest::sourcePortfolioId)).setter(AssociateProductWithPortfolioRequest.setter(Builder::sourcePortfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortfolioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PORTFOLIO_ID_FIELD, SOURCE_PORTFOLIO_ID_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String portfolioId;
    private final String sourcePortfolioId;

    private AssociateProductWithPortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.portfolioId = builder.portfolioId;
        this.sourcePortfolioId = builder.sourcePortfolioId;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    public final String productId() {
        return this.productId;
    }

    public final String portfolioId() {
        return this.portfolioId;
    }

    public final String sourcePortfolioId() {
        return this.sourcePortfolioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortfolioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateProductWithPortfolioRequest)) {
            return false;
        }
        AssociateProductWithPortfolioRequest other = (AssociateProductWithPortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.sourcePortfolioId(), other.sourcePortfolioId());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateProductWithPortfolioRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("PortfolioId", (Object)this.portfolioId()).add("SourcePortfolioId", (Object)this.sourcePortfolioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "SourcePortfolioId": {
                return Optional.ofNullable(clazz.cast(this.sourcePortfolioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateProductWithPortfolioRequest, T> g) {
        return obj -> g.apply((AssociateProductWithPortfolioRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String portfolioId;
        private String sourcePortfolioId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateProductWithPortfolioRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.portfolioId(model.portfolioId);
            this.sourcePortfolioId(model.sourcePortfolioId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getSourcePortfolioId() {
            return this.sourcePortfolioId;
        }

        public final void setSourcePortfolioId(String sourcePortfolioId) {
            this.sourcePortfolioId = sourcePortfolioId;
        }

        @Override
        public final Builder sourcePortfolioId(String sourcePortfolioId) {
            this.sourcePortfolioId = sourcePortfolioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateProductWithPortfolioRequest build() {
            return new AssociateProductWithPortfolioRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateProductWithPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder portfolioId(String var1);

        public Builder sourcePortfolioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

