/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionAssociationErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedServiceActionAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedServiceActionAssociation> {
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedServiceActionAssociation.getter(FailedServiceActionAssociation::serviceActionId)).setter(FailedServiceActionAssociation.setter(Builder::serviceActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedServiceActionAssociation.getter(FailedServiceActionAssociation::productId)).setter(FailedServiceActionAssociation.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedServiceActionAssociation.getter(FailedServiceActionAssociation::provisioningArtifactId)).setter(FailedServiceActionAssociation.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedServiceActionAssociation.getter(FailedServiceActionAssociation::errorCodeAsString)).setter(FailedServiceActionAssociation.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedServiceActionAssociation.getter(FailedServiceActionAssociation::errorMessage)).setter(FailedServiceActionAssociation.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ID_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceActionId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String errorCode;
    private final String errorMessage;

    private FailedServiceActionAssociation(BuilderImpl builder) {
        this.serviceActionId = builder.serviceActionId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public String serviceActionId() {
        return this.serviceActionId;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public ServiceActionAssociationErrorCode errorCode() {
        return ServiceActionAssociationErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeAsString() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedServiceActionAssociation)) {
            return false;
        }
        FailedServiceActionAssociation other = (FailedServiceActionAssociation)obj;
        return Objects.equals(this.serviceActionId(), other.serviceActionId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"FailedServiceActionAssociation").add("ServiceActionId", (Object)this.serviceActionId()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionId": {
                return Optional.ofNullable(clazz.cast(this.serviceActionId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedServiceActionAssociation, T> g) {
        return obj -> g.apply((FailedServiceActionAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceActionId;
        private String productId;
        private String provisioningArtifactId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedServiceActionAssociation model) {
            this.serviceActionId(model.serviceActionId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getServiceActionId() {
            return this.serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ServiceActionAssociationErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public FailedServiceActionAssociation build() {
            return new FailedServiceActionAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedServiceActionAssociation> {
        public Builder serviceActionId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ServiceActionAssociationErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

