/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;

public class GetProvisionedProductOutputsIterable
implements SdkIterable<GetProvisionedProductOutputsResponse> {
    private final ServiceCatalogClient client;
    private final GetProvisionedProductOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetProvisionedProductOutputsIterable(ServiceCatalogClient client, GetProvisionedProductOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetProvisionedProductOutputsResponseFetcher();
    }

    public Iterator<GetProvisionedProductOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetProvisionedProductOutputsResponseFetcher
    implements SyncPageFetcher<GetProvisionedProductOutputsResponse> {
        private GetProvisionedProductOutputsResponseFetcher() {
        }

        public boolean hasNextPage(GetProvisionedProductOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetProvisionedProductOutputsResponse nextPage(GetProvisionedProductOutputsResponse previousPage) {
            if (previousPage == null) {
                return GetProvisionedProductOutputsIterable.this.client.getProvisionedProductOutputs(GetProvisionedProductOutputsIterable.this.firstRequest);
            }
            return GetProvisionedProductOutputsIterable.this.client.getProvisionedProductOutputs((GetProvisionedProductOutputsRequest)((Object)GetProvisionedProductOutputsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

