/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedProductPlanSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedProductPlanSummary> {
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanName").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::planName)).setter(ProvisionedProductPlanSummary.setter(Builder::planName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()}).build();
    private static final SdkField<String> PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanId").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::planId)).setter(ProvisionedProductPlanSummary.setter(Builder::planId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionProductId").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::provisionProductId)).setter(ProvisionedProductPlanSummary.setter(Builder::provisionProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionProductName").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::provisionProductName)).setter(ProvisionedProductPlanSummary.setter(Builder::provisionProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductName").build()}).build();
    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanType").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::planTypeAsString)).setter(ProvisionedProductPlanSummary.setter(Builder::planType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanType").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ProvisionedProductPlanSummary.getter(ProvisionedProductPlanSummary::provisioningArtifactId)).setter(ProvisionedProductPlanSummary.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_NAME_FIELD, PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD, PROVISION_PRODUCT_NAME_FIELD, PLAN_TYPE_FIELD, PROVISIONING_ARTIFACT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String planName;
    private final String planId;
    private final String provisionProductId;
    private final String provisionProductName;
    private final String planType;
    private final String provisioningArtifactId;

    private ProvisionedProductPlanSummary(BuilderImpl builder) {
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionProductName = builder.provisionProductName;
        this.planType = builder.planType;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    public final String planName() {
        return this.planName;
    }

    public final String planId() {
        return this.planId;
    }

    public final String provisionProductId() {
        return this.provisionProductId;
    }

    public final String provisionProductName() {
        return this.provisionProductName;
    }

    public final ProvisionedProductPlanType planType() {
        return ProvisionedProductPlanType.fromValue(this.planType);
    }

    public final String planTypeAsString() {
        return this.planType;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.planName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductPlanSummary)) {
            return false;
        }
        ProvisionedProductPlanSummary other = (ProvisionedProductPlanSummary)obj;
        return Objects.equals(this.planName(), other.planName()) && Objects.equals(this.planId(), other.planId()) && Objects.equals(this.provisionProductId(), other.provisionProductId()) && Objects.equals(this.provisionProductName(), other.provisionProductName()) && Objects.equals(this.planTypeAsString(), other.planTypeAsString()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedProductPlanSummary").add("PlanName", (Object)this.planName()).add("PlanId", (Object)this.planId()).add("ProvisionProductId", (Object)this.provisionProductId()).add("ProvisionProductName", (Object)this.provisionProductName()).add("PlanType", (Object)this.planTypeAsString()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlanName": {
                return Optional.ofNullable(clazz.cast(this.planName()));
            }
            case "PlanId": {
                return Optional.ofNullable(clazz.cast(this.planId()));
            }
            case "ProvisionProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionProductId()));
            }
            case "ProvisionProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionProductName()));
            }
            case "PlanType": {
                return Optional.ofNullable(clazz.cast(this.planTypeAsString()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductPlanSummary, T> g) {
        return obj -> g.apply((ProvisionedProductPlanSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String planName;
        private String planId;
        private String provisionProductId;
        private String provisionProductName;
        private String planType;
        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductPlanSummary model) {
            this.planName(model.planName);
            this.planId(model.planId);
            this.provisionProductId(model.provisionProductId);
            this.provisionProductName(model.provisionProductName);
            this.planType(model.planType);
            this.provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getPlanName() {
            return this.planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        public final String getPlanId() {
            return this.planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        public final String getProvisionProductId() {
            return this.provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        public final String getProvisionProductName() {
            return this.provisionProductName;
        }

        @Override
        public final Builder provisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
            return this;
        }

        public final void setProvisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
        }

        public final String getPlanType() {
            return this.planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(ProvisionedProductPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public ProvisionedProductPlanSummary build() {
            return new ProvisionedProductPlanSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedProductPlanSummary> {
        public Builder planName(String var1);

        public Builder planId(String var1);

        public Builder provisionProductId(String var1);

        public Builder provisionProductName(String var1);

        public Builder planType(String var1);

        public Builder planType(ProvisionedProductPlanType var1);

        public Builder provisioningArtifactId(String var1);
    }
}

