/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningArtifactView
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningArtifactView> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductViewSummary").getter(ProvisioningArtifactView.getter(ProvisioningArtifactView::productViewSummary)).setter(ProvisioningArtifactView.setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build()}).build();
    private static final SdkField<ProvisioningArtifact> PROVISIONING_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningArtifact").getter(ProvisioningArtifactView.getter(ProvisioningArtifactView::provisioningArtifact)).setter(ProvisioningArtifactView.setter(Builder::provisioningArtifact)).constructor(ProvisioningArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD, PROVISIONING_ARTIFACT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProductViewSummary productViewSummary;
    private final ProvisioningArtifact provisioningArtifact;

    private ProvisioningArtifactView(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifact = builder.provisioningArtifact;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public ProvisioningArtifact provisioningArtifact() {
        return this.provisioningArtifact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifact());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactView)) {
            return false;
        }
        ProvisioningArtifactView other = (ProvisioningArtifactView)obj;
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.provisioningArtifact(), other.provisioningArtifact());
    }

    public String toString() {
        return ToString.builder((String)"ProvisioningArtifactView").add("ProductViewSummary", (Object)this.productViewSummary()).add("ProvisioningArtifact", (Object)this.provisioningArtifact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "ProvisioningArtifact": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifact()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactView, T> g) {
        return obj -> g.apply((ProvisioningArtifactView)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private ProvisioningArtifact provisioningArtifact;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactView model) {
            this.productViewSummary(model.productViewSummary);
            this.provisioningArtifact(model.provisioningArtifact);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final ProvisioningArtifact.Builder getProvisioningArtifact() {
            return this.provisioningArtifact != null ? this.provisioningArtifact.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifact(ProvisioningArtifact provisioningArtifact) {
            this.provisioningArtifact = provisioningArtifact;
            return this;
        }

        public final void setProvisioningArtifact(ProvisioningArtifact.BuilderImpl provisioningArtifact) {
            this.provisioningArtifact = provisioningArtifact != null ? provisioningArtifact.build() : null;
        }

        public ProvisioningArtifactView build() {
            return new ProvisioningArtifactView(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningArtifactView> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder provisioningArtifact(ProvisioningArtifact var1);

        default public Builder provisioningArtifact(Consumer<ProvisioningArtifact.Builder> provisioningArtifact) {
            return this.provisioningArtifact((ProvisioningArtifact)((ProvisioningArtifact.Builder)ProvisioningArtifact.builder().applyMutation(provisioningArtifact)).build());
        }
    }
}

