/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactView;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactViewsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisioningArtifactsForServiceActionResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListProvisioningArtifactsForServiceActionResponse> {
    private static final SdkField<List<ProvisioningArtifactView>> PROVISIONING_ARTIFACT_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProvisioningArtifactsForServiceActionResponse.getter(ListProvisioningArtifactsForServiceActionResponse::provisioningArtifactViews)).setter(ListProvisioningArtifactsForServiceActionResponse.setter(Builder::provisioningArtifactViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifactView::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProvisioningArtifactsForServiceActionResponse.getter(ListProvisioningArtifactsForServiceActionResponse::nextPageToken)).setter(ListProvisioningArtifactsForServiceActionResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_ARTIFACT_VIEWS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ProvisioningArtifactView> provisioningArtifactViews;
    private final String nextPageToken;

    private ListProvisioningArtifactsForServiceActionResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactViews = builder.provisioningArtifactViews;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasProvisioningArtifactViews() {
        return this.provisioningArtifactViews != null && !(this.provisioningArtifactViews instanceof SdkAutoConstructList);
    }

    public List<ProvisioningArtifactView> provisioningArtifactViews() {
        return this.provisioningArtifactViews;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactViews());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsForServiceActionResponse)) {
            return false;
        }
        ListProvisioningArtifactsForServiceActionResponse other = (ListProvisioningArtifactsForServiceActionResponse)((Object)obj);
        return Objects.equals(this.provisioningArtifactViews(), other.provisioningArtifactViews()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisioningArtifactsForServiceActionResponse").add("ProvisioningArtifactViews", this.provisioningArtifactViews()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactViews": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactViews()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningArtifactsForServiceActionResponse, T> g) {
        return obj -> g.apply((ListProvisioningArtifactsForServiceActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactView> provisioningArtifactViews = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsForServiceActionResponse model) {
            super(model);
            this.provisioningArtifactViews(model.provisioningArtifactViews);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisioningArtifactView.Builder> getProvisioningArtifactViews() {
            return this.provisioningArtifactViews != null ? (Collection)this.provisioningArtifactViews.stream().map(ProvisioningArtifactView::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactViews(Collection<ProvisioningArtifactView> provisioningArtifactViews) {
            this.provisioningArtifactViews = ProvisioningArtifactViewsCopier.copy(provisioningArtifactViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactViews(ProvisioningArtifactView ... provisioningArtifactViews) {
            this.provisioningArtifactViews(Arrays.asList(provisioningArtifactViews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactViews(Consumer<ProvisioningArtifactView.Builder> ... provisioningArtifactViews) {
            this.provisioningArtifactViews(Stream.of(provisioningArtifactViews).map(c -> (ProvisioningArtifactView)((ProvisioningArtifactView.Builder)ProvisioningArtifactView.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactViews(Collection<ProvisioningArtifactView.BuilderImpl> provisioningArtifactViews) {
            this.provisioningArtifactViews = ProvisioningArtifactViewsCopier.copyFromBuilder(provisioningArtifactViews);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisioningArtifactsForServiceActionResponse build() {
            return new ListProvisioningArtifactsForServiceActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisioningArtifactsForServiceActionResponse> {
        public Builder provisioningArtifactViews(Collection<ProvisioningArtifactView> var1);

        public Builder provisioningArtifactViews(ProvisioningArtifactView ... var1);

        public Builder provisioningArtifactViews(Consumer<ProvisioningArtifactView.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

