/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisioningArtifactMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();
    private static final ProvisioningArtifactMarshaller INSTANCE = new ProvisioningArtifactMarshaller();

    private ProvisioningArtifactMarshaller() {
    }

    public static ProvisioningArtifactMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisioningArtifact provisioningArtifact, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisioningArtifact, (String)"provisioningArtifact");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisioningArtifact.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)provisioningArtifact.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)provisioningArtifact.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)provisioningArtifact.createdTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

