/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;

public class SearchProductsIterable
implements SdkIterable<SearchProductsResponse> {
    private final ServiceCatalogClient client;
    private final SearchProductsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchProductsIterable(ServiceCatalogClient client, SearchProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchProductsResponseFetcher();
    }

    public Iterator<SearchProductsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SearchProductsIterable resume(SearchProductsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchProductsIterable(this.client, (SearchProductsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new SearchProductsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<SearchProductsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class SearchProductsResponseFetcher
    implements SyncPageFetcher<SearchProductsResponse> {
        private SearchProductsResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public SearchProductsResponse nextPage(SearchProductsResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsIterable.this.client.searchProducts(SearchProductsIterable.this.firstRequest);
            }
            return SearchProductsIterable.this.client.searchProducts((SearchProductsRequest)((Object)SearchProductsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

