/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;

public class ListConstraintsForPortfolioPublisher
implements SdkPublisher<ListConstraintsForPortfolioResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListConstraintsForPortfolioRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConstraintsForPortfolioPublisher(ServiceCatalogAsyncClient client, ListConstraintsForPortfolioRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConstraintsForPortfolioPublisher(ServiceCatalogAsyncClient client, ListConstraintsForPortfolioRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConstraintsForPortfolioResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConstraintsForPortfolioResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListConstraintsForPortfolioPublisher resume(ListConstraintsForPortfolioResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListConstraintsForPortfolioPublisher(this.client, (ListConstraintsForPortfolioRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListConstraintsForPortfolioPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListConstraintsForPortfolioResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListConstraintsForPortfolioResponseFetcher
    implements AsyncPageFetcher<ListConstraintsForPortfolioResponse> {
        private ListConstraintsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListConstraintsForPortfolioResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public CompletableFuture<ListConstraintsForPortfolioResponse> nextPage(ListConstraintsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListConstraintsForPortfolioPublisher.this.client.listConstraintsForPortfolio(ListConstraintsForPortfolioPublisher.this.firstRequest);
            }
            return ListConstraintsForPortfolioPublisher.this.client.listConstraintsForPortfolio((ListConstraintsForPortfolioRequest)((Object)ListConstraintsForPortfolioPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

