/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;

public class ListAcceptedPortfolioSharesIterable
implements SdkIterable<ListAcceptedPortfolioSharesResponse> {
    private final ServiceCatalogClient client;
    private final ListAcceptedPortfolioSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAcceptedPortfolioSharesIterable(ServiceCatalogClient client, ListAcceptedPortfolioSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAcceptedPortfolioSharesResponseFetcher();
    }

    public Iterator<ListAcceptedPortfolioSharesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListAcceptedPortfolioSharesIterable resume(ListAcceptedPortfolioSharesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAcceptedPortfolioSharesIterable(this.client, (ListAcceptedPortfolioSharesRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListAcceptedPortfolioSharesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAcceptedPortfolioSharesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAcceptedPortfolioSharesResponseFetcher
    implements SyncPageFetcher<ListAcceptedPortfolioSharesResponse> {
        private ListAcceptedPortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListAcceptedPortfolioSharesResponse nextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return ListAcceptedPortfolioSharesIterable.this.client.listAcceptedPortfolioShares(ListAcceptedPortfolioSharesIterable.this.firstRequest);
            }
            return ListAcceptedPortfolioSharesIterable.this.client.listAcceptedPortfolioShares((ListAcceptedPortfolioSharesRequest)((Object)ListAcceptedPortfolioSharesIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

