/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.Status;
import software.amazon.awssdk.services.servicecatalog.transform.ProductViewDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProductViewDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ProductViewDetail> {
    private final ProductViewSummary productViewSummary;
    private final String status;
    private final String productARN;
    private final Instant createdTime;

    private ProductViewDetail(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.status = builder.status;
        this.productARN = builder.productARN;
        this.createdTime = builder.createdTime;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String productARN() {
        return this.productARN;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewDetail)) {
            return false;
        }
        ProductViewDetail other = (ProductViewDetail)obj;
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.productARN(), other.productARN()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"ProductViewDetail").add("ProductViewSummary", (Object)this.productViewSummary()).add("Status", (Object)this.statusString()).add("ProductARN", (Object)this.productARN()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.of(clazz.cast(this.productViewSummary()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "ProductARN": {
                return Optional.of(clazz.cast(this.productARN()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductViewDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private String status;
        private String productARN;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewDetail model) {
            this.productViewSummary(model.productViewSummary);
            this.status(model.status);
            this.productARN(model.productARN);
            this.createdTime(model.createdTime);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getProductARN() {
            return this.productARN;
        }

        @Override
        public final Builder productARN(String productARN) {
            this.productARN = productARN;
            return this;
        }

        public final void setProductARN(String productARN) {
            this.productARN = productARN;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public ProductViewDetail build() {
            return new ProductViewDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductViewDetail> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().apply(productViewSummary)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder productARN(String var1);

        public Builder createdTime(Instant var1);
    }
}

