/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListConstraintsForPortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
    private final List<ConstraintDetail> constraintDetails;
    private final String nextPageToken;

    private ListConstraintsForPortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.constraintDetails = builder.constraintDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ConstraintDetail> constraintDetails() {
        return this.constraintDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConstraintsForPortfolioResponse)) {
            return false;
        }
        ListConstraintsForPortfolioResponse other = (ListConstraintsForPortfolioResponse)((Object)obj);
        return Objects.equals(this.constraintDetails(), other.constraintDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConstraintsForPortfolioResponse").add("ConstraintDetails", this.constraintDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstraintDetails": {
                return Optional.of(clazz.cast(this.constraintDetails()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ConstraintDetail> constraintDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConstraintsForPortfolioResponse model) {
            this.constraintDetails(model.constraintDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ConstraintDetail.Builder> getConstraintDetails() {
            return this.constraintDetails != null ? (Collection)this.constraintDetails.stream().map(ConstraintDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder constraintDetails(Collection<ConstraintDetail> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copy(constraintDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintDetails(ConstraintDetail ... constraintDetails) {
            this.constraintDetails(Arrays.asList(constraintDetails));
            return this;
        }

        public final void setConstraintDetails(Collection<ConstraintDetail.BuilderImpl> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copyFromBuilder(constraintDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListConstraintsForPortfolioResponse build() {
            return new ListConstraintsForPortfolioResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
        public Builder constraintDetails(Collection<ConstraintDetail> var1);

        public Builder constraintDetails(ConstraintDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

