/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;

public final class SearchProductsAsAdminPaginator
implements SdkIterable<SearchProductsAsAdminResponse> {
    private final ServiceCatalogClient client;
    private final SearchProductsAsAdminRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchProductsAsAdminPaginator(ServiceCatalogClient client, SearchProductsAsAdminRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchProductsAsAdminResponseFetcher();
    }

    public Iterator<SearchProductsAsAdminResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchProductsAsAdminResponseFetcher
    implements NextPageFetcher<SearchProductsAsAdminResponse> {
        private SearchProductsAsAdminResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsAsAdminResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public SearchProductsAsAdminResponse nextPage(SearchProductsAsAdminResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsAsAdminPaginator.this.client.searchProductsAsAdmin(SearchProductsAsAdminPaginator.this.firstRequest);
            }
            return SearchProductsAsAdminPaginator.this.client.searchProductsAsAdmin((SearchProductsAsAdminRequest)((Object)SearchProductsAsAdminPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

