/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;

public final class ListLaunchPathsPaginator
implements SdkIterable<ListLaunchPathsResponse> {
    private final ServiceCatalogClient client;
    private final ListLaunchPathsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListLaunchPathsPaginator(ServiceCatalogClient client, ListLaunchPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLaunchPathsResponseFetcher();
    }

    public Iterator<ListLaunchPathsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListLaunchPathsResponseFetcher
    implements NextPageFetcher<ListLaunchPathsResponse> {
        private ListLaunchPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchPathsResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListLaunchPathsResponse nextPage(ListLaunchPathsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchPathsPaginator.this.client.listLaunchPaths(ListLaunchPathsPaginator.this.firstRequest);
            }
            return ListLaunchPathsPaginator.this.client.listLaunchPaths((ListLaunchPathsRequest)((Object)ListLaunchPathsPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

