/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsAsAdminResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, SearchProductsAsAdminResponse> {
    private final List<ProductViewDetail> productViewDetails;
    private final String nextPageToken;

    private SearchProductsAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetails = builder.productViewDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProductViewDetail> productViewDetails() {
        return this.productViewDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminResponse)) {
            return false;
        }
        SearchProductsAsAdminResponse other = (SearchProductsAsAdminResponse)((Object)obj);
        return Objects.equals(this.productViewDetails(), other.productViewDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"SearchProductsAsAdminResponse").add("ProductViewDetails", this.productViewDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewDetails": {
                return Optional.of(clazz.cast(this.productViewDetails()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProductViewDetail> productViewDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminResponse model) {
            this.productViewDetails(model.productViewDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewDetail.Builder> getProductViewDetails() {
            return this.productViewDetails != null ? (Collection)this.productViewDetails.stream().map(ProductViewDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewDetails(Collection<ProductViewDetail> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copy(productViewDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(ProductViewDetail ... productViewDetails) {
            this.productViewDetails(Arrays.asList(productViewDetails));
            return this;
        }

        public final void setProductViewDetails(Collection<ProductViewDetail.BuilderImpl> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copyFromBuilder(productViewDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsAsAdminResponse build() {
            return new SearchProductsAsAdminResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, SearchProductsAsAdminResponse> {
        public Builder productViewDetails(Collection<ProductViewDetail> var1);

        public Builder productViewDetails(ProductViewDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

