/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordHistoryRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListRecordHistoryRequest> {
    private final String acceptLanguage;
    private final AccessLevelFilter accessLevelFilter;
    private final ListRecordHistorySearchFilter searchFilter;
    private final Integer pageSize;
    private final String pageToken;

    private ListRecordHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.accessLevelFilter = builder.accessLevelFilter;
        this.searchFilter = builder.searchFilter;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public AccessLevelFilter accessLevelFilter() {
        return this.accessLevelFilter;
    }

    public ListRecordHistorySearchFilter searchFilter() {
        return this.searchFilter;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordHistoryRequest)) {
            return false;
        }
        ListRecordHistoryRequest other = (ListRecordHistoryRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.accessLevelFilter(), other.accessLevelFilter()) && Objects.equals(this.searchFilter(), other.searchFilter()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRecordHistoryRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("AccessLevelFilter", (Object)this.accessLevelFilter()).add("SearchFilter", (Object)this.searchFilter()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "AccessLevelFilter": {
                return Optional.of(clazz.cast(this.accessLevelFilter()));
            }
            case "SearchFilter": {
                return Optional.of(clazz.cast(this.searchFilter()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private AccessLevelFilter accessLevelFilter;
        private ListRecordHistorySearchFilter searchFilter;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordHistoryRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.accessLevelFilter(model.accessLevelFilter);
            this.searchFilter(model.searchFilter);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return this.accessLevelFilter != null ? this.accessLevelFilter.toBuilder() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        public final ListRecordHistorySearchFilter.Builder getSearchFilter() {
            return this.searchFilter != null ? this.searchFilter.toBuilder() : null;
        }

        @Override
        public final Builder searchFilter(ListRecordHistorySearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final void setSearchFilter(ListRecordHistorySearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListRecordHistoryRequest build() {
            return new ListRecordHistoryRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, ListRecordHistoryRequest> {
        public Builder acceptLanguage(String var1);

        public Builder accessLevelFilter(AccessLevelFilter var1);

        default public Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return this.accessLevelFilter((AccessLevelFilter)((AccessLevelFilter.Builder)AccessLevelFilter.builder().apply(accessLevelFilter)).build());
        }

        public Builder searchFilter(ListRecordHistorySearchFilter var1);

        default public Builder searchFilter(Consumer<ListRecordHistorySearchFilter.Builder> searchFilter) {
            return this.searchFilter((ListRecordHistorySearchFilter)((ListRecordHistorySearchFilter.Builder)ListRecordHistorySearchFilter.builder().apply(searchFilter)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

