/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProvisioningArtifactRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, CreateProvisioningArtifactRequest> {
    private final String acceptLanguage;
    private final String productId;
    private final ProvisioningArtifactProperties parameters;
    private final String idempotencyToken;

    private CreateProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.parameters = builder.parameters;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public ProvisioningArtifactProperties parameters() {
        return this.parameters;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningArtifactRequest)) {
            return false;
        }
        CreateProvisioningArtifactRequest other = (CreateProvisioningArtifactRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateProvisioningArtifactRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("Parameters", (Object)this.parameters()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "IdempotencyToken": {
                return Optional.of(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private ProvisioningArtifactProperties parameters;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningArtifactRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.parameters(model.parameters);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final ProvisioningArtifactProperties.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(ProvisioningArtifactProperties parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(ProvisioningArtifactProperties.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisioningArtifactRequest build() {
            return new CreateProvisioningArtifactRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, CreateProvisioningArtifactRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder parameters(ProvisioningArtifactProperties var1);

        default public Builder parameters(Consumer<ProvisioningArtifactProperties.Builder> parameters) {
            return this.parameters((ProvisioningArtifactProperties)((ProvisioningArtifactProperties.Builder)ProvisioningArtifactProperties.builder().apply(parameters)).build());
        }

        public Builder idempotencyToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

