/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;

@SdkInternalApi
public class RecordOutputMarshaller {
    private static final MarshallingInfo<String> OUTPUTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputKey").build();
    private static final MarshallingInfo<String> OUTPUTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputValue").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final RecordOutputMarshaller INSTANCE = new RecordOutputMarshaller();

    public static RecordOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordOutput recordOutput, ProtocolMarshaller protocolMarshaller) {
        if (recordOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recordOutput.outputKey(), OUTPUTKEY_BINDING);
            protocolMarshaller.marshall((Object)recordOutput.outputValue(), OUTPUTVALUE_BINDING);
            protocolMarshaller.marshall((Object)recordOutput.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

