/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParametersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateProvisionedProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProvisionedProductRequest> {
    private final String acceptLanguage;
    private final String provisionedProductName;
    private final String provisionedProductId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final List<UpdateProvisioningParameter> provisioningParameters;
    private final String updateToken;

    private UpdateProvisionedProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisioningParameters = builder.provisioningParameters;
        this.updateToken = builder.updateToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public String provisionedProductId() {
        return this.provisionedProductId;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    public List<UpdateProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductRequest)) {
            return false;
        }
        UpdateProvisionedProductRequest other = (UpdateProvisionedProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.provisionedProductName() != null) {
            sb.append("ProvisionedProductName: ").append(this.provisionedProductName()).append(",");
        }
        if (this.provisionedProductId() != null) {
            sb.append("ProvisionedProductId: ").append(this.provisionedProductId()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.provisioningArtifactId() != null) {
            sb.append("ProvisioningArtifactId: ").append(this.provisioningArtifactId()).append(",");
        }
        if (this.pathId() != null) {
            sb.append("PathId: ").append(this.pathId()).append(",");
        }
        if (this.provisioningParameters() != null) {
            sb.append("ProvisioningParameters: ").append(this.provisioningParameters()).append(",");
        }
        if (this.updateToken() != null) {
            sb.append("UpdateToken: ").append(this.updateToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisionedProductName": {
                return Optional.of(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisionedProductId": {
                return Optional.of(clazz.cast(this.provisionedProductId()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.of(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.of(clazz.cast(this.pathId()));
            }
            case "ProvisioningParameters": {
                return Optional.of(clazz.cast(this.provisioningParameters()));
            }
            case "UpdateToken": {
                return Optional.of(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionedProductName;
        private String provisionedProductId;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private List<UpdateProvisioningParameter> provisioningParameters;
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.provisionedProductName(model.provisionedProductName);
            this.provisionedProductId(model.provisionedProductId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
            this.provisioningParameters(model.provisioningParameters);
            this.updateToken(model.updateToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final Collection<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            return this.provisioningParameters != null ? (Collection)this.provisioningParameters.stream().map(UpdateProvisioningParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedProductRequest build() {
            return new UpdateProvisionedProductRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, UpdateProvisionedProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisionedProductId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder provisioningParameters(Collection<UpdateProvisioningParameter> var1);

        public Builder provisioningParameters(UpdateProvisioningParameter ... var1);

        public Builder updateToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

