/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPortfoliosForProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListPortfoliosForProductRequest> {
    private final String acceptLanguage;
    private final String productId;
    private final String pageToken;
    private final Integer pageSize;

    private ListPortfoliosForProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfoliosForProductRequest)) {
            return false;
        }
        ListPortfoliosForProductRequest other = (ListPortfoliosForProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.of(clazz.cast(this.productId()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String pageToken;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfoliosForProductRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.pageToken(model.pageToken);
            this.pageSize(model.pageSize);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListPortfoliosForProductRequest build() {
            return new ListPortfoliosForProductRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, ListPortfoliosForProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

