/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeletePortfolioShareRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DeletePortfolioShareRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String accountId;

    private DeletePortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.accountId = builder.accountId;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String accountId() {
        return this.accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePortfolioShareRequest)) {
            return false;
        }
        DeletePortfolioShareRequest other = (DeletePortfolioShareRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.accountId(), other.accountId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePortfolioShareRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.accountId(model.accountId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeletePortfolioShareRequest build() {
            return new DeletePortfolioShareRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, DeletePortfolioShareRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder accountId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

