/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, CreatePortfolioResponse> {
    private final PortfolioDetail portfolioDetail;
    private final List<Tag> tags;

    private CreatePortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
    }

    public PortfolioDetail portfolioDetail() {
        return this.portfolioDetail;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioResponse)) {
            return false;
        }
        CreatePortfolioResponse other = (CreatePortfolioResponse)((Object)obj);
        return Objects.equals(this.portfolioDetail(), other.portfolioDetail()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.portfolioDetail() != null) {
            sb.append("PortfolioDetail: ").append(this.portfolioDetail()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetail": {
                return Optional.of(clazz.cast(this.portfolioDetail()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private PortfolioDetail portfolioDetail;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioResponse model) {
            this.portfolioDetail(model.portfolioDetail);
            this.tags(model.tags);
        }

        public final PortfolioDetail.Builder getPortfolioDetail() {
            return this.portfolioDetail != null ? this.portfolioDetail.toBuilder() : null;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final void setPortfolioDetail(PortfolioDetail.BuilderImpl portfolioDetail) {
            this.portfolioDetail = portfolioDetail != null ? portfolioDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public CreatePortfolioResponse build() {
            return new CreatePortfolioResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, CreatePortfolioResponse> {
        public Builder portfolioDetail(PortfolioDetail var1);

        default public Builder portfolioDetail(Consumer<PortfolioDetail.Builder> portfolioDetail) {
            return this.portfolioDetail((PortfolioDetail)((PortfolioDetail.Builder)PortfolioDetail.builder().apply(portfolioDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

