/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;

public final class ListPrincipalsForPortfolioPaginator
implements SdkIterable<ListPrincipalsForPortfolioResponse> {
    private final ServiceCatalogClient client;
    private final ListPrincipalsForPortfolioRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPrincipalsForPortfolioPaginator(ServiceCatalogClient client, ListPrincipalsForPortfolioRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPrincipalsForPortfolioResponseFetcher();
    }

    public Iterator<ListPrincipalsForPortfolioResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPrincipalsForPortfolioResponseFetcher
    implements NextPageFetcher<ListPrincipalsForPortfolioResponse> {
        private ListPrincipalsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalsForPortfolioResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListPrincipalsForPortfolioResponse nextPage(ListPrincipalsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalsForPortfolioPaginator.this.client.listPrincipalsForPortfolio(ListPrincipalsForPortfolioPaginator.this.firstRequest);
            }
            return ListPrincipalsForPortfolioPaginator.this.client.listPrincipalsForPortfolio((ListPrincipalsForPortfolioRequest)((Object)ListPrincipalsForPortfolioPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

