/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;

public final class ListPortfoliosForProductPaginator
implements SdkIterable<ListPortfoliosForProductResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosForProductRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPortfoliosForProductPaginator(ServiceCatalogClient client, ListPortfoliosForProductRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfoliosForProductResponseFetcher();
    }

    public Iterator<ListPortfoliosForProductResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPortfoliosForProductResponseFetcher
    implements NextPageFetcher<ListPortfoliosForProductResponse> {
        private ListPortfoliosForProductResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosForProductResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListPortfoliosForProductResponse nextPage(ListPortfoliosForProductResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosForProductPaginator.this.client.listPortfoliosForProduct(ListPortfoliosForProductPaginator.this.firstRequest);
            }
            return ListPortfoliosForProductPaginator.this.client.listPortfoliosForProduct((ListPortfoliosForProductRequest)((Object)ListPortfoliosForProductPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

