/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;

public final class ListAcceptedPortfolioSharesPaginator
implements SdkIterable<ListAcceptedPortfolioSharesResponse> {
    private final ServiceCatalogClient client;
    private final ListAcceptedPortfolioSharesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAcceptedPortfolioSharesPaginator(ServiceCatalogClient client, ListAcceptedPortfolioSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAcceptedPortfolioSharesResponseFetcher();
    }

    public Iterator<ListAcceptedPortfolioSharesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListAcceptedPortfolioSharesResponseFetcher
    implements NextPageFetcher<ListAcceptedPortfolioSharesResponse> {
        private ListAcceptedPortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListAcceptedPortfolioSharesResponse nextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return ListAcceptedPortfolioSharesPaginator.this.client.listAcceptedPortfolioShares(ListAcceptedPortfolioSharesPaginator.this.firstRequest);
            }
            return ListAcceptedPortfolioSharesPaginator.this.client.listAcceptedPortfolioShares((ListAcceptedPortfolioSharesRequest)((Object)ListAcceptedPortfolioSharesPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

