/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePortfolioRequest> {
    private final String acceptLanguage;
    private final String displayName;
    private final String description;
    private final String providerName;
    private final List<Tag> tags;
    private final String idempotencyToken;

    private CreatePortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.tags = builder.tags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String providerName() {
        return this.providerName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioRequest)) {
            return false;
        }
        CreatePortfolioRequest other = (CreatePortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ProviderName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "IdempotencyToken": {
                return Optional.of(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String displayName;
        private String description;
        private String providerName;
        private List<Tag> tags;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.displayName(model.displayName);
            this.description(model.description);
            this.providerName(model.providerName);
            this.tags(model.tags);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = AddTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = AddTagsCopier.copyFromBuilder(tags);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreatePortfolioRequest build() {
            return new CreatePortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder providerName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder idempotencyToken(String var1);
    }
}

